package org.simantics.scl.compiler.constants.singletons;

import org.objectweb.asm.Opcodes;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class IncreaseByOne extends FunctionValue {

    public static final IncreaseByOne INSTANCE = new IncreaseByOne();
    
    private IncreaseByOne() {
        super(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, Types.INTEGER, Types.INTEGER);
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        parameters[0].push(mb);
        mb.loadConstant(1);
        mb.math(Opcodes.IADD);
        return Types.INTEGER;
    }

    @Override
    public String toString() {
        return "increaseByOne";
    }
}
