package org.simantics.scl.compiler.constants.generic;

import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.Type;

public class ParameterStackItem implements StackItem {

    int id;
    Type type;
    
    public ParameterStackItem(int id, Type type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public void push(MethodBuilder mb, Val[] parameters) {
        mb.push(parameters[id], type);
    }
 
    @Override
    public void prepare(MethodBuilder mb) {
    }
}
