package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class ShortConstant extends Constant {
    public static final ShortConstant ZERO = new ShortConstant((short)0);
    public static final ShortConstant ONE = new ShortConstant((short)1);
    public static final ShortConstant MINUS_ONE = new ShortConstant((short)-1);
    
    short value;

    public ShortConstant(short value) {
        super(Types.SHORT);
        this.value = value;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(value);
    }
    
    @Override
    public String toString() {
        return String.valueOf(value);
    }
    
    public short getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ShortConstant other = (ShortConstant) obj;
        if (value != other.value)
            return false;
        return true;
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success,
            Label failure) {
        mb.push(parameter, Types.SHORT);
        mb.loadConstant(value);
        mb.ifComparisonBranch(failure, "!=", TypeDesc.SHORT);
        mb.jump(success);
    }
    
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return value;
    }
}
