package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class LongConstant extends Constant {
    long value;

    public LongConstant(long value) {
        super(Types.LONG);
        this.value = value;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(value);
    }
    
    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (int) (value ^ (value >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        LongConstant other = (LongConstant) obj;
        if (value != other.value)
            return false;
        return true;
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success,
            Label failure) {
        mb.push(parameter, Types.LONG);
        mb.loadConstant(value);
        mb.ifComparisonBranch(failure, "!=", TypeDesc.LONG);
        mb.jump(success);
    }
    
    public int constructorTag() {
        return 0;
    }
    
    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return value;
    }
}
