package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Type;

public class LocalBoxedArrayElementConstant extends Constant {

    LocalVariable var;
    int index;
    
    public LocalBoxedArrayElementConstant(Type type, LocalVariable var, int index) {
        super(type);
        this.var = var;
        this.index = index;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadLocal(var);
        mb.loadConstant(index);
        mb.loadFromArray(TypeDesc.OBJECT);
        mb.unbox(type);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        throw new UnsupportedOperationException();
    }

}
