package org.simantics.scl.compiler.constants;

import org.objectweb.asm.Opcodes;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.OpcodeMnemonics;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class JavaMathOperation extends FunctionValue {
    public static final JavaMathOperation IADD = new JavaMathOperation(Opcodes.IADD, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation ISUB = new JavaMathOperation(Opcodes.ISUB, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IMUL = new JavaMathOperation(Opcodes.IMUL, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IDIV = new JavaMathOperation(Opcodes.IDIV, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IREM = new JavaMathOperation(Opcodes.IREM, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation INEG = new JavaMathOperation(Opcodes.INEG, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IAND = new JavaMathOperation(Opcodes.IAND, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IOR = new JavaMathOperation(Opcodes.IOR, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IXOR = new JavaMathOperation(Opcodes.IXOR, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation ISHL = new JavaMathOperation(Opcodes.ISHL, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation ISHR = new JavaMathOperation(Opcodes.ISHR, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IUSHR = new JavaMathOperation(Opcodes.IUSHR, Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation LADD = new JavaMathOperation(Opcodes.LADD, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LSUB = new JavaMathOperation(Opcodes.LSUB, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LMUL = new JavaMathOperation(Opcodes.LMUL, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LDIV = new JavaMathOperation(Opcodes.LDIV, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LREM = new JavaMathOperation(Opcodes.LREM, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LNEG = new JavaMathOperation(Opcodes.LNEG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LAND = new JavaMathOperation(Opcodes.LAND, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LOR = new JavaMathOperation(Opcodes.LOR, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LXOR = new JavaMathOperation(Opcodes.LXOR, Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LSHL = new JavaMathOperation(Opcodes.LSHL, Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation LSHR = new JavaMathOperation(Opcodes.LSHR, Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation LUSHR = new JavaMathOperation(Opcodes.LUSHR, Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation FADD = new JavaMathOperation(Opcodes.FADD, Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FSUB = new JavaMathOperation(Opcodes.FSUB, Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FMUL = new JavaMathOperation(Opcodes.FMUL, Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FDIV = new JavaMathOperation(Opcodes.FDIV, Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FREM = new JavaMathOperation(Opcodes.FREM, Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FNEG = new JavaMathOperation(Opcodes.FNEG, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation DADD = new JavaMathOperation(Opcodes.DADD, Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DSUB = new JavaMathOperation(Opcodes.DSUB, Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DMUL = new JavaMathOperation(Opcodes.DMUL, Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DDIV = new JavaMathOperation(Opcodes.DDIV, Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DREM = new JavaMathOperation(Opcodes.DREM, Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DNEG = new JavaMathOperation(Opcodes.DNEG, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation LCMP = new JavaMathOperation(Opcodes.LCMP, Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation FCMPG = new JavaMathOperation(Opcodes.FCMPG, Types.FLOAT, Types.FLOAT, Types.INTEGER);
    public static final JavaMathOperation FCMPL = new JavaMathOperation(Opcodes.FCMPL, Types.FLOAT, Types.FLOAT, Types.INTEGER);
    public static final JavaMathOperation DCMPG = new JavaMathOperation(Opcodes.DCMPG, Types.DOUBLE, Types.DOUBLE, Types.INTEGER);
    public static final JavaMathOperation DCMPL = new JavaMathOperation(Opcodes.DCMPL, Types.DOUBLE, Types.DOUBLE, Types.INTEGER);
    
    public static final JavaMathOperation SADD = new JavaMathOperation(Opcodes.IADD, Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SSUB = new JavaMathOperation(Opcodes.ISUB, Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SMUL = new JavaMathOperation(Opcodes.IMUL, Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SDIV = new JavaMathOperation(Opcodes.IDIV, Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SREM = new JavaMathOperation(Opcodes.IREM, Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SNEG = new JavaMathOperation(Opcodes.INEG, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SAND = new JavaMathOperation(Opcodes.IAND, Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SOR = new JavaMathOperation(Opcodes.IOR, Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SXOR = new JavaMathOperation(Opcodes.IXOR, Types.SHORT, Types.SHORT, Types.SHORT);
    
    public static final JavaMathOperation BADD = new JavaMathOperation(Opcodes.IADD, Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BSUB = new JavaMathOperation(Opcodes.ISUB, Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BMUL = new JavaMathOperation(Opcodes.IMUL, Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BDIV = new JavaMathOperation(Opcodes.IDIV, Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BREM = new JavaMathOperation(Opcodes.IREM, Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BNEG = new JavaMathOperation(Opcodes.INEG, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BAND = new JavaMathOperation(Opcodes.IAND, Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BOR = new JavaMathOperation(Opcodes.IOR, Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BXOR = new JavaMathOperation(Opcodes.IXOR, Types.BYTE, Types.BYTE, Types.BYTE);

    public static final JavaMathOperation CADD = new JavaMathOperation(Opcodes.IADD, Types.CHARACTER, Types.CHARACTER, Types.INTEGER);
    public static final JavaMathOperation CSUB = new JavaMathOperation(Opcodes.ISUB, Types.INTEGER, Types.CHARACTER, Types.CHARACTER);
    
    public static final JavaMathOperation[] OPCODES = new JavaMathOperation[] {
        IADD, ISUB, IMUL, IDIV, IREM, INEG, IAND, IOR, IXOR, ISHL, ISHR, IUSHR,
        LADD, LSUB, LMUL, LDIV, LREM, LNEG, LAND, LOR, LXOR, LSHL, LSHR, LUSHR,
        FADD, FSUB, FMUL, FDIV, FREM, FNEG,
        DADD, DSUB, DMUL, DDIV, DREM, DNEG,
        LCMP,
        FCMPG, FCMPL,
        DCMPG, DCMPL
    };
    
    int opcode;
    
    private JavaMathOperation(int opcode, Type returnType, Type ... parameterTypes) {
        super(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, returnType, parameterTypes);
        this.opcode = opcode;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        mb.push(parameters, parameterTypes);
        mb.math(opcode);
        
        return getReturnType();
    }
    
    public String getMnemonic() {
        return OpcodeMnemonics.MNEMONICS[opcode&0xff];
    }
    
    @Override
    public String toString() {
        return getMnemonic();
    }
}