package org.simantics.scl.compiler.constants;

import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Type;

public class ClassConstant extends Constant {    
    Type clazz;

    public ClassConstant(Type type, Type clazz) {
        super(type);
        this.clazz = clazz;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(mb.getJavaTypeTranslator().toTypeDesc(clazz));
    }
    
    @Override
    public String toString() {
        return "(" + clazz.toString() + ")";
    }
    
    @Override
    public int hashCode() {
        return clazz.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ClassConstant other = (ClassConstant) obj;
        return type.equals(other.type) && clazz.equals(other.clazz);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return classBuilder.javaTypeTranslator.toTypeDesc(clazz).toClass();
    }
}
