package org.simantics.scl.compiler.completions;

import org.simantics.scl.compiler.environment.EnvironmentFactory;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.source.TextualModuleSource;

public class CompletionRequest {
    public static final int DEFAULT_MAX_NUMBER_OF_COMPLETIONS = 1000;
    
    public ModuleRepository repository;

    public TextualModuleSource moduleSource;
    
    /**
     * Source text of the SCL module.
     */
    public String sourceText;
    
    /**
     * Cursor position. Cursor is between characters (position-1) and position.
     */
    public int position;
    
    /**
     * Maximum number of completions that will be returned
     */
    public int maxNumberOfCompletions;
    public CompletionRequest() {
        this.maxNumberOfCompletions = DEFAULT_MAX_NUMBER_OF_COMPLETIONS;
    }
    
    public CompletionRequest(ModuleRepository repository, TextualModuleSource moduleSource, String sourceText, int position, int maxNumberOfCompletions) {
        this.repository = repository;
        this.moduleSource = moduleSource;
        this.sourceText = sourceText;
        this.position = position;
        this.maxNumberOfCompletions = maxNumberOfCompletions;
    }
    
    public CompletionRequest(ModuleRepository repository,  TextualModuleSource moduleSource, String sourceText, int position) {
        this(repository, moduleSource, sourceText, position, DEFAULT_MAX_NUMBER_OF_COMPLETIONS);
    }
}
