package org.simantics.scl.compiler.compilation;

import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;

public class NameExistenceChecks {
    public static void checkIfValueExists(ErrorLog errorLog, long location,
            Environment environment, ConcreteModule currentModule, String name) {
        if(SCLCompilerConfiguration.ALLOW_OVERLOADING) {
            if(currentModule.getValue(name) != null) {
                errorLog.log(location,
                        "Value " + name + " has already been defined in this module.");
            }
            return;
        }
        else {
            try {
                SCLValue value = environment.getLocalNamespace().getValue(name);
                if(value != null)
                    errorLog.log(location,
                            "Value " + name + " has already been defined in the module " + 
                                    value.getName().module + 
                            " that is imported to the default namespace.");
            } catch(AmbiguousNameException e) {
                errorLog.log(location,
                        "Value " + name + " has already been defined in the modules " + 
                                e.conflictingModules[0] + " and  " + e.conflictingModules[1] +  
                        " that are imported to the default namespace.");
            }
        }
    }
    
    public static void checkIfTypeExists(ErrorLog errorLog, long location,
            Environment environment, String name) {
        try {
            TypeDescriptor tdesc = environment.getLocalNamespace().getTypeDescriptor(name);
            if(tdesc != null)
                errorLog.log(location,
                        "Type " + name + " has already been defined in the module " + 
                                tdesc.name.module + 
                        " that is imported to the default namespace.");
        } catch(AmbiguousNameException e) {
            errorLog.log(location,
                    "Type " + name + " has already been defined in the modules " + 
                            e.conflictingModules[0] + " and  " + e.conflictingModules[1] +  
                    " that are imported to the default namespace.");
        }
    }
}
