package org.simantics.scl.compiler.compilation;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.internal.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.TCon;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;

public class DocumentationGeneration {
    THashMap<String, DDocumentationAst> valueDocumentation;
    THashMap<String, DDocumentationAst> typeDocumentation;
    THashMap<String, DDocumentationAst> classDocumentation;
    ConcreteModule module;

    THashSet<String> mentionedInDocumentation = new THashSet<String>();    
    THashMap<TCon, ArrayList<TypeClassInstance>> dataToInstance =
            new THashMap<TCon, ArrayList<TypeClassInstance>>(); 
    
    public DocumentationGeneration(/*StringBuilder moduleDocumentation,*/
            THashMap<String, DDocumentationAst> valueDocumentation,
            THashMap<String, DDocumentationAst> typeDocumentation,
            THashMap<String, DDocumentationAst> classDocumentation,
            ConcreteModule module) {
        this.valueDocumentation = valueDocumentation;
        this.typeDocumentation = typeDocumentation;
        this.classDocumentation = classDocumentation;
        this.module = module;
    }
    
    public void generateDocumentation() {
        for(String name : classDocumentation.keySet()) {
            TypeClass typeClass = module.getTypeClass(name);
            DDocumentationAst doc = classDocumentation.get(name);
            if(typeClass != null && doc != null)
                typeClass.setDocumentation(doc.documentation);
        }
        for(String name : valueDocumentation.keySet()) {
            SCLValue value = module.getValue(name);
            DDocumentationAst doc = valueDocumentation.get(name);
            if(value != null && doc != null)
                value.setDocumentation(doc.documentation);
        }
        for(String name : typeDocumentation.keySet()) {
            TypeDescriptor typeConstructor = module.getTypeDescriptor(name);
            DDocumentationAst doc = typeDocumentation.get(name);
            if(typeConstructor != null && doc != null)
                typeConstructor.setDocumentation(doc.documentation);
        }
    }
}
