package org.simantics.scl.compiler.common.names;

import java.io.StringReader;

import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.internal.parsing.parser.SCLLexer;
import org.simantics.scl.compiler.internal.parsing.parser.SCLTerminals;

import gnu.trove.set.hash.THashSet;

public class SCLReservedWords {
    public static final String[] RESERVED_WORDS_ARRAY = {
            "as",
            "by",
            "do",
            "if",
            "in",
            "edo",
            "let",
            "mdo",
            "data",
            "else",
            "rule",
            "then",
            "type",
            "when",
            "with",
            "class",
            "infix",
            "match",
            "where",
            "effect",
            "forall",
            "hiding",
            "import",
            "infixl",
            "infixr",
            "select",
            "enforce",
            "include",
            "ruleset",
            "deriving",
            "instance",
            "constraint",
            "importJava",
            "transformation",
    };

    public static final THashSet<String> RESERVED_WORDS_SET = new THashSet<>();

    static {
        for(String word : RESERVED_WORDS_ARRAY)
            RESERVED_WORDS_SET.add(word);
    }

    public static boolean isReserved(String str) {
        try {
            SCLLexer lexer = new SCLLexer(new StringReader(str));
            Token token = lexer.nextToken();
            return token.id != SCLTerminals.ID;
        } catch(Exception e) {
            return true;
        }
    }
}
