package org.simantics.scl.compiler.commands;

import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.ExpressionEvaluator;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.runtime.function.Function1;

import gnu.trove.map.hash.THashMap;

public class ValueToStringConverter {
    final RuntimeEnvironment environment;
    final THashMap<Type, Function1> showInstances = new THashMap<Type, Function1>(); 

    public ValueToStringConverter(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public String show(Object value, Type type) throws SCLExpressionCompilationException {
        Function1 showInstance = showInstances.get(type);
        if(showInstance == null) {
            showInstance = (Function1)new ExpressionEvaluator(environment, "show")
            .expectedType(Types.function(type, Types.STRING))
            .eval();
            showInstances.put(type, showInstance); 
        }
        return (String)showInstance.apply(value);
    }
}
