/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.simantics.scenegraph.utils.Quality;

public class QualityHints {
    public static final QualityHints HIGH_QUALITY_HINTS = new QualityHints(RenderingHints.VALUE_RENDER_QUALITY, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    public static final QualityHints GOOD_QUALITY_HINTS = new QualityHints(RenderingHints.VALUE_RENDER_DEFAULT, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    public static final QualityHints LOW_QUALITY_HINTS = new QualityHints(RenderingHints.VALUE_RENDER_SPEED, RenderingHints.VALUE_ANTIALIAS_OFF, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    public final Object rendering;
    public final Object antialiasing;
    public final Object textAntiAliasing;
    public final Object interpolation;

    public static QualityHints getHints(Quality forQuality) {
        if (forQuality == null) {
            return null;
        }
        switch (forQuality) {
            case GOOD: {
                return GOOD_QUALITY_HINTS;
            }
            case HIGH: {
                return HIGH_QUALITY_HINTS;
            }
            case LOW: {
                return LOW_QUALITY_HINTS;
            }
        }
        return HIGH_QUALITY_HINTS;
    }

    public QualityHints(Object rendering, Object antialiasing, Object textAntiAliasing, Object interpolation) {
        this.rendering = rendering;
        this.antialiasing = antialiasing;
        this.textAntiAliasing = textAntiAliasing;
        this.interpolation = interpolation;
    }

    public void setQuality(Graphics2D g) {
        if (this.rendering != null) {
            g.setRenderingHint(RenderingHints.KEY_RENDERING, this.rendering);
        }
        if (this.antialiasing != null) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        }
        if (this.textAntiAliasing != null) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAntiAliasing);
        }
        if (this.interpolation != null) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolation);
        }
    }

    public static QualityHints getQuality(Graphics2D g) {
        return new QualityHints(g.getRenderingHint(RenderingHints.KEY_RENDERING), g.getRenderingHint(RenderingHints.KEY_ANTIALIASING), g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING), g.getRenderingHint(RenderingHints.KEY_INTERPOLATION));
    }
}

