/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.utils.page.MarginUtils;

public final class GeometryUtils {
    private static final UndefinedRectangle UNDEFINED_RECTANGLE = new UndefinedRectangle();

    public static double distanceFromLine(Point2D p, Point2D p1, Point2D p2) {
        return GeometryUtils.distanceFromLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p.getX(), p.getY());
    }

    public static double distanceFromLine(double x1, double y1, double x2, double y2, double px, double py) {
        double lineLenSq;
        double lineLen;
        double projLen;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((projLen = dotprod / (lineLen = Math.sqrt(lineLenSq = x2 * x2 + y2 * y2))) < 0.0) {
            return Math.sqrt(px * px + py * py);
        }
        if (projLen > lineLen) {
            double dx = px - x2;
            double dy = py - y2;
            return Math.sqrt(dx * dx + dy * dy);
        }
        return Math.sqrt(px * px + py * py - projLen * projLen);
    }

    public static Point2D intersectionToLine(double x1, double y1, double x2, double y2, double px, double py) {
        double xx2 = x2;
        double yy2 = y2;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        double lineLenSq = x2 * x2 + y2 * y2;
        double lineLen = Math.sqrt(lineLenSq);
        if (lineLen <= Double.MIN_VALUE) {
            return new Point2D.Double(x1, y1);
        }
        double projLen = dotprod / lineLen;
        if (projLen < 0.0) {
            return new Point2D.Double(x1, y1);
        }
        if (projLen > lineLen) {
            return new Point2D.Double(xx2, yy2);
        }
        return new Point2D.Double(x1 + x2 / lineLen * projLen, y1 + y2 / lineLen * projLen);
    }

    public static Rectangle2D expandRectangle(Rectangle2D rect, double top, double bottom, double left, double right) {
        if (rect == null) {
            throw new IllegalArgumentException("null arg");
        }
        rect.setRect(rect.getX() - left, rect.getY() - top, rect.getWidth() + left + right, rect.getHeight() + top + bottom);
        return rect;
    }

    public static Rectangle2D expandRectangle(Rectangle2D rect, double horizontalExpand, double verticalExpand) {
        return GeometryUtils.expandRectangle(rect, verticalExpand, verticalExpand, horizontalExpand, horizontalExpand);
    }

    public static Rectangle2D expandRectangle(Rectangle2D rect, double evenExpand) {
        return GeometryUtils.expandRectangle(rect, evenExpand, evenExpand, evenExpand, evenExpand);
    }

    public static BasicStroke scaleStroke(Stroke stroke, float factor) {
        return GeometryUtils.scaleAndOffsetStroke(stroke, factor, 0.0f);
    }

    public static BasicStroke offsetStroke(Stroke stroke, float offset) {
        BasicStroke s = (BasicStroke)stroke;
        float[] dash = s.getDashArray();
        if (dash == null) {
            return s;
        }
        return new BasicStroke(s.getLineWidth(), s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), dash, s.getDashPhase() + offset);
    }

    public static BasicStroke scaleAndOffsetStroke(Stroke stroke, float factor, float offset) {
        BasicStroke s = (BasicStroke)stroke;
        float[] dash = s.getDashArray();
        if (dash != null) {
            assert (factor != 0.0f);
            dash = GeometryUtils.scaleArray(factor, dash, new float[dash.length]);
        }
        if (dash == null) {
            return new BasicStroke(s.getLineWidth() * factor, s.getEndCap(), s.getLineJoin(), s.getMiterLimit());
        }
        return new BasicStroke(s.getLineWidth() * factor, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), dash, s.getDashPhase() * factor + offset);
    }

    public static BasicStroke scaleStrokeWidth(Stroke stroke, float factor) {
        BasicStroke s = (BasicStroke)stroke;
        return new BasicStroke(s.getLineWidth() * factor, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
    }

    public static BasicStroke scaleAndOffsetStrokeWidth(Stroke stroke, float factor, float widthOffset) {
        BasicStroke s = (BasicStroke)stroke;
        return new BasicStroke(s.getLineWidth() * factor + widthOffset, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
    }

    public static float[] scaleArray(float factor, float[] array, float[] targetArray) {
        assert (array != null);
        if (targetArray == null) {
            targetArray = new float[array.length];
        }
        int i = 0;
        while (i < array.length) {
            targetArray[i] = array[i] * factor;
            ++i;
        }
        return targetArray;
    }

    public static double getScale(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        return Math.sqrt(Math.abs(m00 * m11 - m10 * m01));
    }

    public static Point2D getScale2D(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        double sx = Math.sqrt(m00 * m00 + m10 * m10);
        double sy = Math.sqrt(m01 * m01 + m11 * m11);
        return new Point2D.Double(sx, sy);
    }

    public static double getMaxScale(AffineTransform at) {
        double m01;
        double m10;
        double determinant;
        double m11;
        double m00 = at.getScaleX();
        double trace = m00 + (m11 = at.getScaleY());
        double dd = trace * trace * 0.25 - (determinant = m00 * m11 - (m10 = at.getShearY()) * (m01 = at.getShearX()));
        if (dd >= 0.0) {
            return Math.abs(trace * 0.5) + Math.sqrt(dd);
        }
        return Math.sqrt(determinant);
    }

    public static AffineTransform fitArea(Rectangle2D controlArea, Rectangle2D diagramArea) {
        double controlAspectRatio = controlArea.getWidth() / controlArea.getHeight();
        double canvasAspectRatio = diagramArea.getWidth() / diagramArea.getHeight();
        double scale = 1.0;
        double tx = 0.0;
        double ty = 0.0;
        if (controlAspectRatio > canvasAspectRatio) {
            scale = controlArea.getHeight() / diagramArea.getHeight();
            tx = (controlArea.getWidth() - diagramArea.getWidth() * scale) / 2.0;
        } else {
            scale = controlArea.getWidth() / diagramArea.getWidth();
            ty = (controlArea.getHeight() - diagramArea.getHeight() * scale) / 2.0;
        }
        AffineTransform at = new AffineTransform();
        at.translate(tx, ty);
        at.translate(controlArea.getMinX(), controlArea.getMinY());
        at.scale(scale, scale);
        at.translate(-diagramArea.getMinX(), -diagramArea.getMinY());
        return at;
    }

    public static Rectangle2D transformRectangle(AffineTransform transform, Rectangle2D rect) {
        int type = transform.getType();
        if (type == 0) {
            return new Rectangle2D.Double(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
        }
        if ((type & 0x30) == 0) {
            double Y1;
            double Y0;
            double X1;
            double X0;
            double x0 = rect.getMinX();
            double y0 = rect.getMinY();
            double x1 = rect.getMaxX();
            double y1 = rect.getMaxY();
            double m00 = transform.getScaleX();
            double m10 = transform.getShearY();
            double m01 = transform.getShearX();
            double m11 = transform.getScaleY();
            if (m00 > 0.0) {
                X0 = m00 * x0;
                X1 = m00 * x1;
            } else {
                X1 = m00 * x0;
                X0 = m00 * x1;
            }
            if (m01 > 0.0) {
                X0 += m01 * y0;
                X1 += m01 * y1;
            } else {
                X1 += m01 * y0;
                X0 += m01 * y1;
            }
            if (m10 > 0.0) {
                Y0 = m10 * x0;
                Y1 = m10 * x1;
            } else {
                Y1 = m10 * x0;
                Y0 = m10 * x1;
            }
            if (m11 > 0.0) {
                Y0 += m11 * y0;
                Y1 += m11 * y1;
            } else {
                Y1 += m11 * y0;
                Y0 += m11 * y1;
            }
            return new Rectangle2D.Double(X0 + transform.getTranslateX(), Y0 + transform.getTranslateY(), X1 - X0, Y1 - Y0);
        }
        return transform.createTransformedShape(rect).getBounds2D();
    }

    public static Rectangle2D transformRectangleInv(AffineTransform transform, Rectangle2D rect) {
        double Y1;
        double Y0;
        double X1;
        double X0;
        assert ((transform.getType() & 0x30) == 0);
        double[] mx = new double[6];
        transform.getMatrix(mx);
        double x0 = rect.getMinX() - mx[4];
        double y0 = rect.getMinY() - mx[5];
        double x1 = rect.getMaxX() - mx[4];
        double y1 = rect.getMaxY() - mx[5];
        double det = mx[0] * mx[3] - mx[1] * mx[2];
        double m00 = mx[3] / det;
        double m10 = -mx[1] / det;
        double m01 = -mx[2] / det;
        double m11 = mx[0] / det;
        if (m00 > 0.0) {
            X0 = m00 * x0;
            X1 = m00 * x1;
        } else {
            X1 = m00 * x0;
            X0 = m00 * x1;
        }
        if (m01 > 0.0) {
            X0 += m01 * y0;
            X1 += m01 * y1;
        } else {
            X1 += m01 * y0;
            X0 += m01 * y1;
        }
        if (m10 > 0.0) {
            Y0 = m10 * x0;
            Y1 = m10 * x1;
        } else {
            Y1 = m10 * x0;
            Y0 = m10 * x1;
        }
        if (m11 > 0.0) {
            Y0 += m11 * y0;
            Y1 += m11 * y1;
        } else {
            Y1 += m11 * y0;
            Y0 += m11 * y1;
        }
        return new Rectangle2D.Double(X0, Y0, X1 - X0, Y1 - Y0);
    }

    public static float pointToMillimeter(float points) {
        return points * 25.4f / 72.0f;
    }

    public static double pointToMillimeter(double points) {
        return points * 25.4 / 72.0;
    }

    public static AffineTransform fitArea(Rectangle2D controlArea, Rectangle2D diagramArea, MarginUtils.Margins margins) {
        diagramArea = GeometryUtils.expandRectangle(diagramArea, margins.top.diagramAbsolute, margins.bottom.diagramAbsolute, margins.left.diagramAbsolute, margins.right.diagramAbsolute);
        controlArea = GeometryUtils.expandRectangle(controlArea, -margins.top.controlAbsolute - margins.top.controlRelative * controlArea.getHeight(), -margins.bottom.controlAbsolute - margins.bottom.controlRelative * controlArea.getHeight(), -margins.left.controlAbsolute - margins.left.controlRelative * controlArea.getWidth(), -margins.right.controlAbsolute - margins.right.controlRelative * controlArea.getWidth());
        double controlAspectRatio = controlArea.getWidth() / controlArea.getHeight();
        double canvasAspectRatio = diagramArea.getWidth() / diagramArea.getHeight();
        double scale = 1.0;
        double tx = 0.0;
        double ty = 0.0;
        if (controlAspectRatio > canvasAspectRatio) {
            scale = controlArea.getHeight() / diagramArea.getHeight();
            tx = (controlArea.getWidth() - diagramArea.getWidth() * scale) / 2.0;
        } else {
            scale = controlArea.getWidth() / diagramArea.getWidth();
            ty = (controlArea.getHeight() - diagramArea.getHeight() * scale) / 2.0;
        }
        AffineTransform at = new AffineTransform();
        at.translate(tx, ty);
        at.translate(controlArea.getMinX(), controlArea.getMinY());
        at.scale(scale, scale);
        at.translate(-diagramArea.getMinX(), -diagramArea.getMinY());
        return at;
    }

    public static Rectangle2D undefinedRectangle() {
        return UNDEFINED_RECTANGLE;
    }

    public static boolean isUndefinedRectangle(Rectangle2D r) {
        return r == UNDEFINED_RECTANGLE || r.isEmpty() && Double.isNaN(r.getX()) && Double.isNaN(r.getY());
    }

    private static class UndefinedRectangle
    extends Rectangle2D {
        private UndefinedRectangle() {
        }

        @Override
        public void setRect(double x, double y, double w, double h) {
            throw new UnsupportedOperationException("UndefinedRectangle is immutable");
        }

        @Override
        public int outcode(double x, double y) {
            return 15;
        }

        private Rectangle2D copy(Rectangle2D r) {
            Rectangle2D dest = r instanceof Rectangle2D.Float ? new Rectangle2D.Float() : new Rectangle2D.Double();
            dest.setFrame(r);
            return dest;
        }

        @Override
        public Rectangle2D createIntersection(Rectangle2D r) {
            return this.copy(r);
        }

        @Override
        public Rectangle2D createUnion(Rectangle2D r) {
            return this.copy(r);
        }

        @Override
        public double getX() {
            return Double.NaN;
        }

        @Override
        public double getY() {
            return Double.NaN;
        }

        @Override
        public double getWidth() {
            return 0.0;
        }

        @Override
        public double getHeight() {
            return 0.0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

