/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.color.ColorFilter;
import org.simantics.scenegraph.g2d.color.Graphics2DWithColorFilter;

public class BufferedImage {
    SVGDiagram source;
    Rectangle2D imageBounds;
    Point referenceSize;
    java.awt.image.BufferedImage buffer = null;
    AffineTransform previousTransform = null;
    ColorFilter previousColorFilter = null;

    public BufferedImage(SVGDiagram original, Rectangle2D imageBounds, Point referenceSize) {
        this.source = original;
        this.imageBounds = imageBounds;
        this.referenceSize = referenceSize;
    }

    public BufferedImage(SVGDiagram original) {
        this.source = original;
        this.imageBounds = original.getViewRect();
        this.referenceSize = null;
    }

    public java.awt.image.BufferedImage getBuffer() {
        return this.buffer;
    }

    public void finalize() throws Throwable {
        this.releaseRaster();
        super.finalize();
    }

    public synchronized void releaseRaster() {
        this.source = null;
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
    }

    public void paintToBuffer(AffineTransform transform, float margin) throws SVGException {
        this.paintToBuffer(transform, margin);
    }

    public void paintToBuffer(AffineTransform transform, ColorFilter colorFilter, float margin) throws SVGException {
        int w = (int)((this.imageBounds.getWidth() + (double)(margin * 2.0f)) * transform.getScaleX());
        int h = (int)((this.imageBounds.getHeight() + (double)(margin * 2.0f)) * transform.getScaleY());
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        this.buffer = new java.awt.image.BufferedImage(w, h, 2);
        Graphics2D b2g = (Graphics2D)this.buffer.getGraphics();
        b2g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        b2g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        b2g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        b2g.setBackground(Color.WHITE);
        b2g.clearRect(0, 0, w, h);
        b2g.translate(margin, margin);
        b2g.scale(transform.getScaleX(), transform.getScaleY());
        b2g.translate(-this.imageBounds.getMinX(), -this.imageBounds.getMinY());
        if (colorFilter != null) {
            this.source.render((Graphics2D)new Graphics2DWithColorFilter(b2g, colorFilter));
        } else {
            this.source.render(b2g);
        }
    }

    public void paint(Graphics2D g) {
        float margin = 5.0f;
        ColorFilter colorFilter = (ColorFilter)g.getRenderingHint(G2DRenderingHints.KEY_COLOR_FILTER);
        if (this.previousTransform == null || this.previousTransform.getScaleX() != g.getTransform().getScaleX() || this.previousTransform.getScaleY() != g.getTransform().getScaleY() || !Objects.equals(colorFilter, this.previousColorFilter)) {
            try {
                this.previousColorFilter = colorFilter;
                this.previousTransform = (AffineTransform)g.getTransform().clone();
                this.paintToBuffer(this.previousTransform, this.previousColorFilter, margin);
            }
            catch (SVGException e) {
                e.printStackTrace();
            }
        }
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        AffineTransform at = (AffineTransform)g.getTransform().clone();
        try {
            g.translate(this.imageBounds.getMinX(), this.imageBounds.getMinY());
            g.scale(1.0 / this.previousTransform.getScaleX(), 1.0 / this.previousTransform.getScaleY());
            g.translate(-margin, -margin);
            g.drawImage((Image)this.buffer, 0, 0, null);
        }
        finally {
            g.setTransform(at);
        }
    }
}

