/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.snap;

import java.awt.geom.Point2D;
import java.io.Serializable;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scl.runtime.function.Function1;

public class GridSnapAdvisor
implements ISnapAdvisor,
Serializable {
    private static final long serialVersionUID = 2411311098028229134L;
    double resolution;
    boolean enabled = true;
    Function1<Object, Boolean> enabledFunction;

    public GridSnapAdvisor(double resolution) {
        this.resolution = resolution;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabledFunction(Function1<Object, Boolean> function) {
        this.enabledFunction = function;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public double getResolution() {
        return this.resolution;
    }

    @Override
    public void snap(Point2D point) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.enabledFunction != null && !((Boolean)this.enabledFunction.apply(null)).booleanValue()) {
            return;
        }
        point.setLocation((double)Math.round(point.getX() / this.resolution) * this.resolution, (double)Math.round(point.getY() / this.resolution) * this.resolution);
    }

    @Override
    public void snap(Point2D point, Point2D[] features) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.enabledFunction != null && !((Boolean)this.enabledFunction.apply(null)).booleanValue()) {
            return;
        }
        double dx = features[0].getX();
        double dy = features[0].getY();
        point.setLocation((double)Math.round((point.getX() - dx) / this.resolution) * this.resolution + dx, (double)Math.round((point.getY() - dy) / this.resolution) * this.resolution + dy);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[resolution=" + this.resolution + "]";
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.resolution);
        return (int)(temp ^ temp >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridSnapAdvisor other = (GridSnapAdvisor)obj;
        return Double.doubleToLongBits(this.resolution) != Double.doubleToLongBits(other.resolution);
    }
}

