/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.simantics.scenegraph.g2d.nodes.BoxSelectionStrategy;
import org.simantics.scenegraph.g2d.nodes.SelectionPolicy;

public class TwoWayBoxSelectionStrategy
implements BoxSelectionStrategy {
    private final Color containColor;
    private final Color intersectColor;

    public TwoWayBoxSelectionStrategy(Color containColor, Color intersectColor) {
        this.containColor = containColor;
        this.intersectColor = intersectColor;
    }

    private static boolean expandsToRight(Point2D start, Point2D end) {
        return start.getX() < end.getX();
    }

    @Override
    public Color selectionBoxColor(Point2D start, Point2D end) {
        if (TwoWayBoxSelectionStrategy.expandsToRight(start, end)) {
            return this.containColor;
        }
        return this.intersectColor;
    }

    @Override
    public SelectionPolicy chooseSelectionPolicy(Point2D start, Point2D end) {
        return TwoWayBoxSelectionStrategy.expandsToRight(start, end) ? SelectionPolicy.SELECT_CONTAINED : SelectionPolicy.SELECT_INTERSECTING;
    }
}

