/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;

public class Trend2DNode
extends G2DNode {
    private static final long serialVersionUID = 8508750881358776559L;
    protected Rectangle2D bounds = null;
    protected transient List<TrendPoint> points = null;
    protected Integer x = 0;
    protected Integer y = 0;

    @INode.SyncField(value={"x", "y"})
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @INode.SyncField(value={"points"})
    protected void setPoints(List<TrendPoint> points) {
        this.points = points;
    }

    @INode.ClientSide
    protected void appendPoints(List<TrendPoint> points) {
        if (this.points == null) {
            this.points = new ArrayList<TrendPoint>();
        }
        if (this.location.equals((Object)INode.Location.REMOTE)) {
            this.points.addAll(points);
        }
        this.repaint();
    }

    public void updatePoints(List<TrendPoint> newpoints) {
        if (this.points == null) {
            this.points = new ArrayList<TrendPoint>();
        }
        int n = newpoints.size() - 1;
        while (n >= 0) {
            int t = 0;
            int o = this.points.size() - 1;
            while (o >= 0) {
                if (!newpoints.get(n - t).equals(this.points.get(o))) break;
                if (o == 0 || o < this.points.size() - 10) {
                    ArrayList<TrendPoint> appendedPoints = new ArrayList<TrendPoint>();
                    int i = n;
                    while (i < newpoints.size() - 1) {
                        appendedPoints.add(newpoints.get(i));
                        ++i;
                    }
                    this.points = new ArrayList<TrendPoint>(newpoints);
                    if (appendedPoints != null && appendedPoints.size() > 0) {
                        this.appendPoints(appendedPoints);
                    }
                    return;
                }
                if (n - t == 0) {
                    this.setPoints(newpoints);
                    return;
                }
                ++t;
                --o;
            }
            --n;
        }
        this.setPoints(newpoints);
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.points == null || this.bounds == null) {
            return;
        }
        AffineTransform ot = g2d.getTransform();
        g2d.translate(this.x, this.y);
        double max_y = Double.MIN_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_x = Double.MIN_VALUE;
        double min_x = Double.MAX_VALUE;
        int index = this.points.size() - 1;
        while (index >= 0) {
            double y = this.points.get(index).getY();
            double x = this.points.get(index).getX();
            if (y > max_y) {
                max_y = y;
            }
            if (y < min_y) {
                min_y = y;
            }
            if (x > max_x) {
                max_x = x;
            }
            if (x < min_x) {
                min_x = x;
            }
            --index;
        }
        if (min_y > 0.0) {
            min_y = 0.0;
        }
        if (max_y < 0.0) {
            max_y = 0.0;
        }
        double mid_y = 0.5 * (max_y + min_y);
        GeneralPath path = new GeneralPath();
        double scalex = this.bounds.getWidth() / (max_x - min_x);
        double scalefactor = 0.0;
        double height = this.bounds.getHeight() - 2.0;
        if (max_y - min_y > 0.0) {
            scalefactor = height / (max_y - min_y);
        }
        int index2 = this.points.size() - 1;
        while (index2 >= 0) {
            double t = this.bounds.getMinX();
            float px = (float)((this.points.get(index2).getX() - min_x) * scalex + t);
            float py = (float)((mid_y - this.points.get(index2).getY()) * scalefactor + (this.bounds.getY() + 0.5 * height) + 1.0);
            if (path.getCurrentPoint() == null) {
                path.moveTo(px, py);
            } else {
                path.lineTo(px, py);
            }
            --index2;
        }
        g2d.setColor(Color.WHITE);
        g2d.fill(this.bounds);
        g2d.setColor(Color.RED);
        g2d.setStroke(new BasicStroke(0.2f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.draw(path);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        float w = (float)(0.2 * g2d.getTransform().getScaleX() < 1.0 ? 1.0 / g2d.getTransform().getScaleX() : 0.2);
        g2d.setStroke(new BasicStroke(w));
        g2d.setColor(new Color(200, 200, 200));
        g2d.draw(this.bounds);
        GeneralPath axes = new GeneralPath();
        axes.moveTo((float)this.bounds.getMinX() - 1.0f, (float)this.bounds.getMinY());
        axes.lineTo((float)this.bounds.getMinX(), (float)this.bounds.getMinY());
        axes.lineTo((float)this.bounds.getMinX(), (float)this.bounds.getMaxY());
        axes.moveTo((float)this.bounds.getMinX() - 1.0f, (float)this.bounds.getMaxY());
        axes.lineTo((float)this.bounds.getMaxX(), (float)this.bounds.getMaxY());
        axes.lineTo((float)this.bounds.getMaxX(), (float)this.bounds.getMaxY() + 1.0f);
        g2d.setColor(Color.BLACK);
        g2d.draw(axes);
        DecimalFormat eformat = new DecimalFormat("###E0");
        DecimalFormat format = new DecimalFormat("0.0#");
        String max = Math.abs(max_y) > 1000.0 ? eformat.format(max_y) : format.format(max_y);
        String min = Math.abs(min_y) > 1000.0 ? eformat.format(min_y) : format.format(min_y);
        Font font = Font.decode("Arial 5");
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        double x1 = this.bounds.getMinX() - fm.getStringBounds(max, g2d).getWidth() - 0.3;
        double x2 = this.bounds.getMinX() - fm.getStringBounds(min, g2d).getWidth() - 0.3;
        double y1 = this.bounds.getMinY() + fm.getStringBounds(max, g2d).getHeight() / 2.0;
        double y2 = this.bounds.getMaxY() + fm.getStringBounds(max, g2d).getHeight() / 2.0;
        g2d.drawString(max, (float)x1, (float)y1);
        g2d.drawString(min, (float)x2, (float)y2);
        DecimalFormat tformat = new DecimalFormat("#.0");
        String time = tformat.format(max_x);
        g2d.drawString(time, (float)(this.bounds.getMaxX() - fm.getStringBounds(time, g2d).getWidth() / 2.0), (float)(this.bounds.getMaxY() + fm.getStringBounds(time, g2d).getHeight()));
        g2d.setTransform(ot);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    public static class TrendPoint
    implements Serializable {
        private static final long serialVersionUID = -3135433049709995399L;
        public double x;
        public double y;

        public TrendPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean equals(TrendPoint b) {
            double deltax = Math.abs(b.getX() - this.getX());
            double deltay = Math.abs(b.getY() - this.getY());
            return deltax < 1.0E-7 && deltay < 1.0E-7;
        }
    }
}

