/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IdentityAffineTransform;

public class TransformNode
extends G2DParentNode {
    private static final long serialVersionUID = -3722167807691239528L;

    @INode.SyncField(value={"transform"})
    public void rotate(double theta) {
        if (this.transform == IdentityAffineTransform.INSTANCE) {
            this.transform = AffineTransform.getRotateInstance(theta);
        } else {
            this.transform.rotate(theta);
        }
    }

    @INode.SyncField(value={"transform"})
    public void translate(double x, double y) {
        if (this.transform == IdentityAffineTransform.INSTANCE) {
            this.transform = AffineTransform.getTranslateInstance(x, y);
        } else {
            this.transform.translate(x, y);
        }
    }

    @INode.SyncField(value={"transform"})
    public void scale(double x, double y) {
        if (this.transform == IdentityAffineTransform.INSTANCE) {
            this.transform = AffineTransform.getScaleInstance(x, y);
        } else {
            this.transform.scale(x, y);
        }
    }

    @Override
    public void render(Graphics2D g2d) {
        super.render(g2d);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

