/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.utils.GeometryUtils;

public class RelationshipNode2
extends G2DNode
implements Decoration {
    private static final long serialVersionUID = 3517235896431855937L;
    public static transient double PADDING = 1.0;
    protected Stroke boxStroke = null;
    protected Stroke lineStroke = null;
    protected Color boxColor = null;
    protected Color lineColor = null;
    protected Point2D p1 = null;
    protected Point2D p2 = null;
    private transient Rectangle2D boundsInLocal = null;
    private transient float phase = 0.0f;
    private transient Line2D line = new Line2D.Double();

    @INode.SyncField(value={"linestroke", "linecolor", "p1", "p2"})
    public void init(Stroke lineStroke, Color lineColor, Point2D p1, Point2D p2) {
        this.lineStroke = lineStroke;
        this.lineColor = lineColor;
        this.p1 = p1;
        this.p2 = p2;
        this.boundsInLocal = this.calculateLocalBounds();
    }

    @Override
    public void render(Graphics2D g) {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        this.phase = (float)((double)this.phase + 0.2);
        if (this.phase > 10.0f) {
            this.phase -= 10.0f;
        }
        float scale = (float)(1.0 / GeometryUtils.getScale(g.getTransform()));
        float scaledPhase = scale * this.phase;
        if (this.lineStroke != null && this.lineColor != null) {
            if (this.lineStroke != this.boxStroke) {
                g.setStroke(GeometryUtils.scaleAndOffsetStroke(this.lineStroke, scale, scaledPhase));
            }
            if (this.lineColor != this.boxColor) {
                g.setColor(this.lineColor);
            }
            this.line.setLine(this.p1, this.p2);
            g.draw(this.line);
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.boundsInLocal;
    }

    private Rectangle2D calculateLocalBounds() {
        if (this.p1 == null || this.p2 == null) {
            return null;
        }
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(this.p1, this.p2);
        return r;
    }
}

