/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.StateMaskNode;

public class LocalDelegateNode
extends StateMaskNode {
    private static final long serialVersionUID = -7465071303188585400L;
    IG2DNode delegate;

    public void setDelegate(IG2DNode delegate) {
        this.delegate = delegate;
    }

    public IG2DNode getDelegate() {
        return this.delegate;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.hasFlags((byte)1)) {
            return;
        }
        if (this.delegate == null) {
            return;
        }
        this.setFlags((byte)1);
        AffineTransform oldTransform = null;
        if (this.transform != null && !this.transform.isIdentity()) {
            g2d.transform(this.transform);
            oldTransform = g2d.getTransform();
        }
        try {
            this.delegate.render(g2d);
        }
        catch (Throwable throwable) {
            if (oldTransform != null) {
                g2d.setTransform(oldTransform);
            }
            this.clearFlags((byte)1);
            throw throwable;
        }
        if (oldTransform != null) {
            g2d.setTransform(oldTransform);
        }
        this.clearFlags((byte)1);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.hasFlags((byte)2)) {
            return new Rectangle2D.Double();
        }
        if (this.delegate == null) {
            return new Rectangle2D.Double();
        }
        this.setFlags((byte)2);
        try {
            Rectangle2D bounds = this.delegate.getBoundsInLocal();
            if (this.transform != null && !this.transform.isIdentity()) {
                bounds = this.transform.createTransformedShape(bounds).getBounds2D();
            }
            Rectangle2D rectangle2D = bounds;
            return rectangle2D;
        }
        finally {
            this.clearFlags((byte)2);
        }
    }
}

