/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.utils.TextUtil;

public class GalleryItemNode
extends TransformNode {
    private static final long serialVersionUID = -423827087534629381L;
    protected String text = "";
    protected Rectangle2D bounds = null;
    protected Rectangle2D imagebounds = null;
    protected Font font = null;

    @INode.SyncField(value={"text", "bounds", "font", "imagebounds"})
    public void init(String text, Rectangle2D bounds, Font font, Rectangle2D imagebounds) {
        this.text = text;
        this.bounds = bounds;
        this.font = font;
        this.imagebounds = imagebounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        double contentDim = Math.min(this.bounds.getWidth(), this.bounds.getHeight());
        AffineTransform ot = g2d.getTransform();
        if (!this.transform.isIdentity()) {
            g2d.transform(this.transform);
        }
        if (this.text != null) {
            Graphics2D g = (Graphics2D)g2d.create();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Rectangle2D.Double textRectangle = new Rectangle2D.Double(0.0, contentDim, this.bounds.getWidth(), this.bounds.getHeight() - contentDim);
            g.setClip(textRectangle);
            g.setColor(Color.BLACK);
            g.setFont(this.font);
            FontMetrics metrics = g.getFontMetrics();
            int fontHeight = metrics.getHeight();
            float width = (float)this.bounds.getWidth();
            float y = (float)this.bounds.getWidth() + (float)fontHeight;
            int i = 0;
            String[] stringArray = TextUtil.wordWrap(this.text, metrics, (int)((RectangularShape)textRectangle).getWidth());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int sWidth = metrics.stringWidth(s);
                g.drawString(s, (width - (float)sWidth) / 2.0f, y + (float)(i * fontHeight));
                ++i;
                ++n2;
            }
            g.dispose();
        }
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n3 = 0;
        while (n3 < n) {
            IG2DNode n4 = iG2DNodeArray[n3];
            double imgMaxDim = Math.max(this.imagebounds.getWidth(), this.imagebounds.getHeight());
            double scaleFactor = contentDim / imgMaxDim;
            double xCenteringOffset = -(this.imagebounds.getWidth() - imgMaxDim) / 2.0;
            double yCenteringOffset = -(this.imagebounds.getHeight() - imgMaxDim) / 2.0;
            AffineTransform at = g2d.getTransform();
            g2d.scale(scaleFactor, scaleFactor);
            g2d.translate(-this.imagebounds.getMinX(), -this.imagebounds.getMinY());
            g2d.translate(xCenteringOffset, yCenteringOffset);
            n4.render(g2d);
            g2d.setTransform(at);
            ++n3;
        }
        g2d.setTransform(ot);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    @Override
    public String toString() {
        return super.toString() + " [text=" + this.text + "]";
    }
}

