/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.TransformNode;

public class BorderDecoratorNode
extends TransformNode {
    private static final long serialVersionUID = -4982578347433716440L;
    protected Composite composite;
    protected Boolean visible = Boolean.TRUE;
    protected Rectangle2D bounds = null;
    protected float border = 1.0f;

    @INode.SyncField(value={"composite"})
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    @INode.SyncField(value={"visible"})
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @INode.PropertySetter(value="Stroke Width")
    @INode.SyncField(value={"border"})
    public void setBorderWidth(Float borderWidth) {
        this.border = borderWidth != null ? borderWidth.floatValue() : 1.0f;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @INode.PropertySetter(value="Bounds")
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    @Override
    public void render(Graphics2D g) {
        if (!this.visible.booleanValue()) {
            return;
        }
        if (this.composite != null) {
            g.setComposite(this.composite);
        }
        if (this.border > 0.0f && this.bounds != null) {
            AffineTransform ot = g.getTransform();
            g.transform(this.transform);
            g.setStroke(new BasicStroke(this.border));
            g.setColor(Color.BLACK);
            g.draw(this.bounds);
            g.setTransform(ot);
        }
        super.render(g);
    }
}

