/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.lang.reflect.Method;
import java.util.LinkedList;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.utils.datastructures.ListenerList;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

public class EventQueue
implements IEventQueue,
IEventHandler {
    ListenerList<IEventQueue.IEventQueueListener> listeners = new ListenerList(IEventQueue.IEventQueueListener.class);
    SyncListenerList<IEventQueue.IEventQueueListener> listeners2 = new SyncListenerList(IEventQueue.IEventQueueListener.class);
    ListenerList<IEventQueue.EventCoalescer> coalescers = new ListenerList(IEventQueue.EventCoalescer.class);
    LinkedList<Event> queue = new LinkedList();
    IEventHandler handler;
    Method onEventAdded = SyncListenerList.getMethod(IEventQueue.IEventQueueListener.class, (String)"onEventAdded");
    Method onQueueEmpty = SyncListenerList.getMethod(IEventQueue.IEventQueueListener.class, (String)"onQueueEmpty");

    public EventQueue(IEventHandler handler) {
        assert (handler != null);
        this.handler = handler;
    }

    @Override
    public int getEventMask() {
        return EventTypes.AnyMask;
    }

    @Override
    public synchronized void queueEvent(Event e) {
        IEventQueue.EventCoalescer[] css = (IEventQueue.EventCoalescer[])this.coalescers.getListeners();
        if (css.length > 0 && !this.queue.isEmpty()) {
            Event last = this.queue.get(this.queue.size() - 1);
            Event coalesced = null;
            IEventQueue.EventCoalescer[] eventCoalescerArray = css;
            int n = css.length;
            int n2 = 0;
            while (n2 < n) {
                IEventQueue.EventCoalescer ecs = eventCoalescerArray[n2];
                coalesced = ecs.coalesce(last, e);
                if (coalesced != null) break;
                ++n2;
            }
            if (coalesced == last) {
                return;
            }
            if (coalesced != null) {
                this.queue.remove(this.queue.size() - 1);
                this.queue.addLast(coalesced);
                int index = this.queue.size() - 1;
                this.fireEventAdded(coalesced, index);
                return;
            }
        }
        this.queue.addLast(e);
        int index = this.queue.size() - 1;
        this.fireEventAdded(e, index);
    }

    @Override
    public synchronized void queueFirst(Event e) {
        IEventQueue.EventCoalescer[] css = (IEventQueue.EventCoalescer[])this.coalescers.getListeners();
        if (css.length > 0 && !this.queue.isEmpty()) {
            Event first = this.queue.get(0);
            Event coalesced = null;
            IEventQueue.EventCoalescer[] eventCoalescerArray = css;
            int n = css.length;
            int n2 = 0;
            while (n2 < n) {
                IEventQueue.EventCoalescer ecs = eventCoalescerArray[n2];
                coalesced = ecs.coalesce(e, first);
                if (coalesced != null) break;
                ++n2;
            }
            if (coalesced == first) {
                return;
            }
            if (coalesced != null) {
                this.queue.remove(0);
                this.queue.addFirst(coalesced);
                this.fireEventAdded(coalesced, 0);
                return;
            }
        }
        this.queue.addFirst(e);
        this.fireEventAdded(e, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents() {
        int eventsHandled = 0;
        Event[] events = null;
        do {
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                events = this.queue.toArray(new Event[this.queue.size()]);
                this.queue.clear();
            }
            Event[] eventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                Event e = eventArray[n2];
                if (EventTypes.passes(this.handler, e)) {
                    this.handler.handleEvent(e);
                }
                ++eventsHandled;
                ++n2;
            }
        } while (events.length > 0);
        if (eventsHandled > 0) {
            this.fireQueueEmpty();
        }
    }

    @Override
    public void addEventCoalesceler(IEventQueue.EventCoalescer coalescaler) {
        this.coalescers.add((Object)coalescaler);
    }

    @Override
    public void removeEventCoalesceler(IEventQueue.EventCoalescer coalescaler) {
        this.coalescers.remove((Object)coalescaler);
    }

    @Override
    public boolean handleEvent(Event e) {
        this.handleEvents();
        return EventTypes.passes(this.handler, e) ? this.handler.handleEvent(e) : false;
    }

    @Override
    public void addQueueListener(IEventQueue.IEventQueueListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void removeQueueListener(IEventQueue.IEventQueueListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireEventAdded(Event e, int index) {
        IEventQueue.IEventQueueListener[] iEventQueueListenerArray = (IEventQueue.IEventQueueListener[])this.listeners.getListeners();
        int n = iEventQueueListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEventQueue.IEventQueueListener eql = iEventQueueListenerArray[n2];
            eql.onEventAdded(this, e, index);
            ++n2;
        }
        this.listeners2.fireEventSync(this.onEventAdded, new Object[]{this, e, index});
    }

    protected void fireQueueEmpty() {
        IEventQueue.IEventQueueListener[] iEventQueueListenerArray = (IEventQueue.IEventQueueListener[])this.listeners.getListeners();
        int n = iEventQueueListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEventQueue.IEventQueueListener eql = iEventQueueListenerArray[n2];
            eql.onQueueEmpty(this);
            ++n2;
        }
        this.listeners2.fireEventSync(this.onQueueEmpty, new Object[]{this});
    }

    @Override
    public void addQueueListener(IEventQueue.IEventQueueListener listener, IThreadWorkQueue thread) {
        this.listeners2.add(thread, (Object)listener);
    }

    @Override
    public void removeQueueListener(IEventQueue.IEventQueueListener listener, IThreadWorkQueue thread) {
        this.listeners2.remove(thread, (Object)listener);
    }
}

