/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.color;

import java.awt.Color;
import org.simantics.scenegraph.g2d.color.ColorFilter;

public class RGBAColorFilter
implements ColorFilter {
    private double r;
    private double g;
    private double b;
    private double a;

    public RGBAColorFilter(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    @Override
    public Color filter(Color c) {
        int avg = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
        int R = Math.min(255, (int)((double)avg * this.r));
        int G = Math.min(255, (int)((double)avg * this.g));
        int B = Math.min(255, (int)((double)avg * this.b));
        int A = Math.min(255, (int)((double)c.getAlpha() * this.a));
        Color c2 = new Color(R, G, B, A);
        return c2;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.g);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.r);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGBAColorFilter other = (RGBAColorFilter)obj;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(other.a)) {
            return false;
        }
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(other.b)) {
            return false;
        }
        if (Double.doubleToLongBits(this.g) != Double.doubleToLongBits(other.g)) {
            return false;
        }
        return Double.doubleToLongBits(this.r) == Double.doubleToLongBits(other.r);
    }
}

