/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simantics.scenegraph.g2d.color.ColorFilter;

public class ColorFilterStack
implements ColorFilter {
    private List<ColorFilter> colorFilters = new ArrayList<ColorFilter>(2);

    public void addColorFilter(ColorFilter colorFilter) {
        this.colorFilters.add(colorFilter);
    }

    @Override
    public Color filter(Color c) {
        for (ColorFilter f : this.colorFilters) {
            c = f.filter(c);
        }
        return c;
    }

    public int hashCode() {
        return Objects.hash(this.colorFilters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorFilterStack)) {
            return false;
        }
        ColorFilterStack other = (ColorFilterStack)obj;
        return Objects.equals(this.colorFilters, other.colorFilters);
    }
}

