/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.utils;

import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.PageBorderNode;

public class SceneGraphUtil {
	public static void zoomToFit(G2DParentNode root) {
		NavigationNode nav = NodeUtil.getNearestChildByClass(root, NavigationNode.class);
		if(nav != null) {
			Rectangle2D diagram = nav.getBoundsInLocal(true);
			nav.zoomTo(diagram);
		}
		// TODO: use margins..
//		util.fitArea(rect, diagramRect, new Margins(MarginUtils.MARGIN2, new Margin(0.10, 0, 0), MarginUtils.MARGIN2, MarginUtils.MARGIN2));
	}
	
	public static void zoomToPage(G2DParentNode root) {
    	PageBorderNode page = NodeUtil.getNearestChildByClass(root, PageBorderNode.class);
		NavigationNode nav = NodeUtil.getNearestChildByClass(root, NavigationNode.class);
		if(nav != null && page != null) {
			nav.zoomTo(page.getBoundsInLocal(true));
		} else if(nav != null && page == null) {
			// Fallback to zoomToFit
			Rectangle2D diagram = nav.getBoundsInLocal(true);
			nav.zoomTo(diagram);
		}
	}
}
