/*******************************************************************************
 * Copyright (c) 2020 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.snap;

import java.awt.geom.Point2D;

public class RelativeScaleSnapAdvisor implements ISnapAdvisor {

    private boolean enabled = true;
    private double step;

    public RelativeScaleSnapAdvisor(double step) {
        this.step = step;
    }

    @Override
    public void snap(Point2D point) {
        point.setLocation(
                Math.pow(1 + step, Math.round(Math.log(point.getX()) / Math.log(1 + step))),
                Math.pow(1 + step, Math.round(Math.log(point.getY()) / Math.log(1 + step))));
    }

    @Override
    public void snap(Point2D point, Point2D[] features) {
        snap(point);
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        enabled = value;
    }

}
