/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import org.simantics.scenegraph.g2d.G2DNode;

/**
 * @author Tuukka Lehtonen
 */
public abstract class StateMaskNode extends G2DNode {

    private static final long serialVersionUID = 5614241810541732707L;

    protected static final byte IN_RENDER        = 1 << 0;
    protected static final byte IN_GET_BOUNDS    = 1 << 1;

    protected transient byte    flags            = 0;

    protected boolean hasFlags(byte mask) {
        return (flags & mask) != 0;
    }

    protected byte setFlags(byte mask) {
        flags |= mask;
        return flags;
    }

    protected byte clearFlags(byte mask) {
        flags &= ~mask;
        return flags;
    }

}