/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;

public class SelectionPivotNode extends G2DNode {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1382614767907193882L;

	public transient static final BasicStroke SELECTION_STROKE = new BasicStroke(1.0f,
            BasicStroke.CAP_SQUARE, BasicStroke.CAP_SQUARE, 10.0f);

    protected Point2D pivot = null;
    
    @SyncField("pivot")
    public void setPivot(Point2D pivot) {
        this.pivot = pivot;
    }

    @Override
    public void render(Graphics2D g) {
    	AffineTransform ot = g.getTransform();
    	
        g.setColor(Color.RED);
        g.translate(pivot.getX(), pivot.getY());

        double scale = GeometryUtils.getScale(g.getTransform());
        double scaleRecip = 1.0 / scale;

        g.setStroke(GeometryUtils.scaleStroke(SELECTION_STROKE, (float) scaleRecip)); 

        double padding = 5.0 * scaleRecip;
        float d = (float) padding;

        GeneralPath p = new GeneralPath();
        p.moveTo(-d, 0);
        p.lineTo(d, 0);
        p.moveTo(0, -d);
        p.lineTo(0, d);

        g.draw(p);
        
        g.setTransform(ot);
    }

	@Override
	public Rectangle2D getBoundsInLocal() {
		return new Rectangle2D.Double(pivot.getX()-5, pivot.getY()-5, 10, 10);
	}

}
