/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;

/**
 * A non-renderable parent node for the 2D scene graph ({@link G2DSceneGraph}).
 * Does not perform any child rendering, but is meant for storing static/shared
 * data inside a scene graph and making it referable through
 * {@link ILookupService}.
 * 
 * @author Tuukka Lehtonen
 */
public class DataNode extends G2DParentNode {

    private static final long serialVersionUID = 6008781343639770034L;

    @Override
    public void render(Graphics2D g2d) {
        // This node is meant to prevent rendering anything under it.
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }

}