/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.geom.Point2D;

/**
 * @author Tuukka Lehtonen
 * @since 1.58.0
 */
public class ConstantBoxSelectionStrategy implements BoxSelectionStrategy {

	private final Color color;
	private final SelectionPolicy policy;

	public ConstantBoxSelectionStrategy(Color color, SelectionPolicy policy) {
		this.color = color;
		this.policy = policy;
	}

	@Override
	public Color selectionBoxColor(Point2D start, Point2D end) {
		return color;
	}

	@Override
	public SelectionPolicy chooseSelectionPolicy(Point2D start, Point2D end) {
		return policy;
	}

}