/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.scenegraph.g2d.events;

import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * 
 * @see MouseEventCoalescer
 * @see EventQueue Default implementation
 * @author Toni Kalajainen
 */
public interface IEventQueue {

    /**
     * queues event
     * 
     * @param e
     */
    void queueEvent(Event e);

    /**
     * Queue event as next to be processed
     * 
     * @param e
     */
    void queueFirst(Event e);

    boolean isEmpty();

    int size();

    void addEventCoalesceler(EventCoalescer coalescaler);
    void removeEventCoalesceler(EventCoalescer coalescaler);

    void addQueueListener(IEventQueueListener listener);
    void removeQueueListener(IEventQueueListener listener);
    void addQueueListener(IEventQueueListener listener, IThreadWorkQueue thread);
    void removeQueueListener(IEventQueueListener listener, IThreadWorkQueue thread);

    /**
     * Coalesces mouse events.
     */
    public interface EventCoalescer {
        /**
         * 
         * @param apriori
         * @param aposterior
         * @return coalesced event of the two or <code>null</code> if the two
         *         events cannot be coalesced
         */
        Event coalesce(Event apriori, Event aposterior);
    }

    public interface IEventQueueListener {
        void onEventAdded(IEventQueue queue, Event e, int index);
        void onQueueEmpty(IEventQueue queue);
    }

}
