/*******************************************************************************
 * Copyright (c) 2020 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.color;

import java.awt.Color;

public class RGBAColorFilter implements ColorFilter {

    private double r, g, b, a;
    
    public RGBAColorFilter(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    @Override
    public Color filter(Color c) {
        int avg = (c.getRed() + c.getGreen() + c.getBlue()) / 3; 
        int R = Math.min(255, (int)(avg * r));
        int G = Math.min(255, (int)(avg * g));
        int B = Math.min(255, (int)(avg * b));
        int A = Math.min(255, (int)(c.getAlpha() * a));
        Color c2 = new Color(R, G, B, A);
        return c2;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        long temp;
        temp = Double.doubleToLongBits(a);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(b);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(g);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(r);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        RGBAColorFilter other = (RGBAColorFilter) obj;
        if (Double.doubleToLongBits(a) != Double.doubleToLongBits(other.a))
            return false;
        if (Double.doubleToLongBits(b) != Double.doubleToLongBits(other.b))
            return false;
        if (Double.doubleToLongBits(g) != Double.doubleToLongBits(other.g))
            return false;
        if (Double.doubleToLongBits(r) != Double.doubleToLongBits(other.r))
            return false;
        return true;
    }
}
