/*******************************************************************************
 * Copyright (c) 2020 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.color;

import java.awt.Color;

public class BWColorFilter implements ColorFilter {

    @Override
    public Color filter(Color c) {
        int avg = (c.getRed() + c.getGreen() + c.getBlue()) / 3; 
        Color c2 = new Color(avg, avg, avg, c.getAlpha());
        return c2;
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        return true;
    }
}
