/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

/**
 * An optimization for memory consumption to keep down the allocation of
 * unnecessary identity-type affine transforms. This will be used as the default
 * affine transform in {@link G2DNode} and {@link G2DParentNode}.
 * 
 * @author Tuukka Lehtonen
 */
public class IdentityAffineTransform extends AffineTransform {

    public static final IdentityAffineTransform INSTANCE = new IdentityAffineTransform();

    private static final long serialVersionUID = 7843049586639496587L;

    private IdentityAffineTransform() {
        // No self-construction.
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public void translate(double tx, double ty) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotate(double theta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotate(double theta, double anchorx, double anchory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotate(double vecx, double vecy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotate(double vecx, double vecy, double anchorx, double anchory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void quadrantRotate(int numquadrants) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void quadrantRotate(int numquadrants, double anchorx, double anchory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scale(double sx, double sy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shear(double shx, double shy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToIdentity() {
        // NOP
    }

    @Override
    public void setToTranslation(double tx, double ty) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToRotation(double theta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToRotation(double theta, double anchorx, double anchory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToRotation(double vecx, double vecy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToQuadrantRotation(int numquadrants) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToQuadrantRotation(int numquadrants, double anchorx, double anchory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToScale(double sx, double sy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToShear(double shx, double shy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void concatenate(AffineTransform Tx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void preConcatenate(AffineTransform Tx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invert() throws NoninvertibleTransformException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        return new AffineTransform();
    }

}