/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;

import javax.swing.JComponent;
import javax.swing.RepaintManager;


public class G2DRepaintManager extends RepaintManager {
        private RepaintManager delegate;
        private Class<?> rootClass;
        private final static Rectangle NULL_RECTANGLE = new Rectangle();
        private final static Dimension NULL_DIMENSION = new Dimension();
        public G2DRepaintManager(Class<?> rootClass, RepaintManager repaintManager) {
            //System.out.println("G2DRepaintManager(" + System.identityHashCode(this) + ", " + rootClass + ", " + repaintManager.getClass() + ")");
            delegate = repaintManager;
            this.rootClass = rootClass;
        }
        
        void setDelegate(RepaintManager manager) {
            //System.out.println("G2DRepaintManager(" + System.identityHashCode(this) + ").setDelegate(" + manager + ")");
            this.delegate = manager;
        }
        
        public RepaintManager getDelegate() {
        	return this.delegate;
        }
        
        @Override
        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            final JComponent root = (JComponent) getAncestorOfClass(rootClass, c);
            if (root != null) {
            	delegate.markCompletelyDirty(root);
            } else if (delegate != null) {
                delegate.addDirtyRegion(c, x, y, w, h);
            }
        }
        
        @Override
        public void addInvalidComponent(JComponent invalidComponent) {
            if (delegate != null) {
                delegate.addInvalidComponent(invalidComponent);
            }
        }

        @Override
        public Rectangle getDirtyRegion(JComponent component) {
            if (delegate != null) {
                return delegate.getDirtyRegion(component);
            } else {
                return NULL_RECTANGLE;
            }
        }

        @Override
        public Dimension getDoubleBufferMaximumSize() {
            if (delegate != null) {
                return delegate.getDoubleBufferMaximumSize();
            } else {
                assert false;
                return NULL_DIMENSION;
            }
        }

        @Override
        public Image getOffscreenBuffer(Component c, int proposedWidth,
                int proposedHeight) {
            if (delegate != null) {
                return delegate.getOffscreenBuffer(c, proposedWidth, proposedHeight);
            } else {
                assert false;
                return null;
            }
        }

        @Override
        public Image getVolatileOffscreenBuffer(Component c, int proposedWidth,
                int proposedHeight) {
            if (delegate != null) {
                return delegate.getVolatileOffscreenBuffer(c, proposedWidth,
                        proposedHeight);
            } else {
                assert false;
                return null;
            }
        }

        @Override
        public boolean isCompletelyDirty(JComponent component) {
            if (delegate != null) {
                return delegate.isCompletelyDirty(component);
            } else {
                assert false;
                return false;
            }
        }

        @Override
        public boolean isDoubleBufferingEnabled() {
            if (delegate != null) {
                return delegate.isDoubleBufferingEnabled();
            } else {
                assert false;
                return false;
            }
        }

        @Override
        public void markCompletelyClean(JComponent component) {
            if (delegate != null) {
                delegate.markCompletelyClean(component);
            }
        }

        public static Container getAncestorOfClass(Class<?> c, Component comp)
        {
            if(comp == null || c == null)
                return null;

            if (c.isInstance(comp) && comp instanceof Container)
                return (Container) comp;

            Container parent = comp.getParent();
            while(parent != null && !(c.isInstance(parent)))
                parent = parent.getParent();
            return parent;
        }
        
        @Override
        public void markCompletelyDirty(JComponent component) {
            final JComponent root = (JComponent) getAncestorOfClass(rootClass, component);
            if (root != null) {
            	delegate.markCompletelyDirty(root);
            } else if (delegate != null) {
                delegate.markCompletelyDirty(component);
            }
        }

        @Override
        public void paintDirtyRegions() {
//        	new Exception("paintDirtyRegions " + delegate).printStackTrace();
            if (delegate != null) {
                delegate.paintDirtyRegions();
            } else {
                assert false;
            }
        }
        
        @Override
        public void removeInvalidComponent(JComponent component) {
            if (delegate != null) {
                delegate.removeInvalidComponent(component);
            } else {
                assert false;
            }
        }

        @Override
        public void setDoubleBufferingEnabled(boolean flag) {
            if (delegate != null) {
                delegate.setDoubleBufferingEnabled(flag);
            } else {
                assert false;
            }
        }

        @Override
        public void setDoubleBufferMaximumSize(Dimension d) {
            if (delegate != null) {
                delegate.setDoubleBufferMaximumSize(d);
            } else {
                assert false;
            }
        }

        @Override
        public void validateInvalidComponents() {
            if (delegate != null) {
                delegate.validateInvalidComponents();
            } else {
                assert false;
            }
        }
    }
