/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - GitLab #597
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.RenderingHints.Key;

/**
 * @author Toni Kalajainen
 */
public final class G2DPDFRenderingHints {

    private static boolean isClassName(String className, Object val) {
        return val != null && val.getClass().getName().equals(className);
    }

    private static boolean isInstanceOf(String className, Object val) {
        try {
            var clazz = G2DPDFRenderingHints.class.getClassLoader().loadClass(className);
            return val != null && clazz.isInstance(val);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /** A rendering hint for storing the ExportPdfWriter object. */
    public static final Key KEY_EXPORT_PDF_WRITER = new Key(2003) {
        @Override
        public boolean isCompatibleValue(Object val) {
            // Intentionally not taking class hierarchy into account, only expecting to see this class alone.
            return isClassName("org.simantics.export.core.pdf.ExportPdfWriter", val);
        }
    };

    /**
     * A rendering hint for storing the root PDF ByteContent on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_PDF_BYTECONTENT = new Key(2000) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return isInstanceOf("com.lowagie.text.pdf.PdfContentByte", val);
        }
    };

    /**
     * A rendering hint for storing the root PDF writer on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_PDF_WRITER = new Key(2001) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return isInstanceOf("com.lowagie.text.pdf.PdfWriter", val);
        }
    };

    /**
     * A rendering hint for storing the root PDF Font Mapper on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_PDF_FONTMAPPER = new Key(2002) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return isInstanceOf("com.lowagie.text.pdf.FontMapper", val);
        }
    };

}