/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.animation;

import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * Custom executor for animation (no Simantics dependency)
 * 
 * @author J-P
 *
 */
public class AnimationExecutor {

	private static AnimationExecutor instance = null;
	private ScheduledThreadPoolExecutor executor = null;
	
	private AnimationExecutor() {
		executor = new ScheduledThreadPoolExecutor(1);
	}
	
	public static AnimationExecutor getInstance() {
		if (instance == null)
			instance = new AnimationExecutor();
		return instance;
	}

	public void animate(IAnimation animation) {
		executor.execute(animation);
	}
}
