/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.adapters;

import java.awt.event.AWTEventListener;

import org.simantics.scenegraph.g2d.G2DSceneGraph;

/**
 * Interface for resources that provide scene graph view
 * Currently only 2D scene graph is supported
 * 
 * @author jplaine
 *
 */
public interface ISceneGraphProvider {
	/**
	 * 
	 * @param sg Initialized G2DSceneGraph instance 
	 * @return sg
	 */
	public G2DSceneGraph initializeSceneGraph(G2DSceneGraph sg);

    public G2DSceneGraph initializeSceneGraph(G2DSceneGraph sg, String modelURI, String RVI);

	/**
	 * 
	 * @param sg Initialized G2DSceneGraph instance 
	 * @param view Layer other view identifier. If null, default is used
	 * @return sg
	 */
	public G2DSceneGraph initializeSceneGraph(G2DSceneGraph sg, String view);

	public AWTEventListener getEventListener();
	
	/**
	 * Method for passing parameters for initialization. Basically the key should be IHintContext.Key, but it doesn't have to be.
	 * The detailed list of supported keys and values should be described in implementation.
	 * 
	 * @param key Hint key
	 * @param value Hint value
	 */
	public void setHint(Object key, Object value);
	
	public void dispose();
}
