/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;
import org.simantics.scenegraph.profile.request.AvailableProfiles;
import org.simantics.scenegraph.profile.request.ProfileActiveEntryResources;
import org.simantics.scenegraph.profile.request.ProfileEntryContributions;

public class RuntimeProfileActiveEntryResources
extends ResourceRead<Collection<Resource>> {
    public RuntimeProfileActiveEntryResources(Resource resource) {
        super(resource);
    }

    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        Resource rootEntries;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        result.addAll((Collection)graph.syncRequest((Read)new ProfileEntryContributions(this.resource)));
        Resource activeProfile = graph.getPossibleObject(this.resource, DIA.RuntimeDiagram_HasRuntimeProfile);
        if (activeProfile == null) {
            List available = (List)graph.syncRequest((Read)new AvailableProfiles(this.resource));
            if (available.size() != 1) {
                return result;
            }
            activeProfile = ((NamedResource)available.iterator().next()).getResource();
        }
        if ((rootEntries = graph.getPossibleObject(activeProfile, DIA.HasEntries)) == null) {
            return result;
        }
        if (graph.isImmutable(activeProfile)) {
            Resource activationState = ProfileUtils.getPossibleProfileActivationState(graph, this.resource, activeProfile);
            if (activationState != null) {
                result.addAll((Collection)graph.syncRequest((Read)new ProfileActiveEntryResources(activationState, rootEntries)));
            }
        } else {
            result.addAll((Collection)graph.syncRequest((Read)new ProfileActiveEntryResources(activeProfile, rootEntries)));
        }
        return result;
    }
}

