/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class ProfileUtils {
    public static List<Resource> getProfileChildren(ReadGraph graph, Resource profile) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource entries = graph.getPossibleObject(profile, DIA.HasEntries);
        if (entries == null) {
            return Collections.emptyList();
        }
        return ProfileUtils.getProfileChildrenFromEntries(graph, entries);
    }

    public static List<Resource> getProfileChildrenFromEntries(ReadGraph graph, Resource entries) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        return (List)graph.getRelatedValue2(entries, DIA.Profile_children, (Object)entries);
    }

    public static List<Resource> safeGetProfileChildrenFromEntries(ReadGraph graph, Resource entries) throws DatabaseException {
        return graph.hasStatement(entries) ? ProfileUtils.getProfileChildrenFromEntries(graph, entries) : Collections.emptyList();
    }

    public static Resource getPossibleProfileActivationState(ReadGraph graph, Resource runtimeDiagram, Resource profile) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource conf = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (conf == null) {
            return null;
        }
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(conf));
        if (indexRoot == null) {
            return null;
        }
        for (Resource state : (Collection)graph.syncRequest((Read)new ObjectsWithType(indexRoot, L0.ConsistsOf, DIA.ProfileActivationState))) {
            Resource ref = graph.getPossibleObject(state, DIA.ProfileActivationState_HasProfile);
            if (!profile.equals(ref)) continue;
            return state;
        }
        return null;
    }

    public static Resource claimProfileActivationState(WriteGraph graph, Resource runtimeDiagram, Resource runtimeProfile, Resource entry) throws DatabaseException {
        Resource state2;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource conf = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (conf == null) {
            return null;
        }
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(conf));
        if (indexRoot == null) {
            return null;
        }
        for (Resource state2 : (Collection)graph.syncRequest((Read)new ObjectsWithType(indexRoot, L0.ConsistsOf, DIA.ProfileActivationState))) {
            Resource profile = graph.getPossibleObject(state2, DIA.ProfileActivationState_HasProfile);
            if (!profile.equals(runtimeProfile)) continue;
            return state2;
        }
        state2 = graph.newResource();
        graph.claim(state2, L0.InstanceOf, DIA.ProfileActivationState);
        graph.claimLiteral(state2, L0.HasName, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claim(state2, DIA.ProfileActivationState_HasProfile, runtimeProfile);
        graph.claim(indexRoot, L0.ConsistsOf, state2);
        return state2;
    }

    public static boolean isActive(ReadGraph graph, Resource runtimeDiagram, Resource profile, Resource entry) throws DatabaseException {
        Resource state;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        return graph.isInstanceOf(entry, DIA.ProfileEntry) && (graph.isImmutable(profile) ? (state = ProfileUtils.getPossibleProfileActivationState(graph, runtimeDiagram, profile)) != null && graph.hasStatement(state, SIMU.IsActive, entry) : graph.hasStatement(profile, SIMU.IsActive, entry));
    }
}

