package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

public class AvailableProfiles extends ResourceRead<List<NamedResource>>{

	protected AvailableProfiles(Resource runtimeDiagram) {
		super(runtimeDiagram);
	}

	@Override
	public List<NamedResource> perform(ReadGraph graph) throws DatabaseException {
		
		  Layer0 L0 = Layer0.getInstance(graph);
	        DiagramResource DIA = DiagramResource.getInstance(graph);

	        String indexURI = graph.getPossibleRelatedValue(resource, DIA.RuntimeDiagram_HasModelURI);
	        if (indexURI == null)
	            return Collections.emptyList();

	        Resource index = graph.getPossibleResource(indexURI);
	        if (index == null)
	            return Collections.emptyList();

	        Instances query = graph.adapt(DIA.Profile, Instances.class);

	        ArrayList<NamedResource> result = new ArrayList<>();
	        for(Resource profile : query.find(graph, index)) {
	        	if(!graph.hasStatement(profile, L0.Abstract)) {
	        		String name = graph.getRelatedValue(profile, L0.HasName, Bindings.STRING);
	        		result.add(new NamedResource(name, profile));
	        	}
	        }
	        
	        return result;
	        
	}

}