/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile.impl;

import org.eclipse.core.runtime.Platform;


/**
 * @author Tuukka Lehtonen
 */
public final class DebugPolicy {

    public static boolean DEBUG = false;

    // PROFILES

    public static boolean DEBUG_PROFILE_ENTRIES              = false;
    public static boolean DEBUG_PROFILE_OBSERVER_UPDATE      = false;
    public static boolean DEBUG_PROFILE_OBSERVER_PERFORM     = false;
    public static boolean DEBUG_PROFILE_STYLE_ACTIVATION     = false;
    public static boolean DEBUG_PROFILE_STYLE_GROUP_TRACKING = false;
    public static boolean DEBUG_PROFILE_STYLE_APPLICATION    = false;

    static {
        if (Activator.getDefault().isDebugging()) {
            DEBUG = true;
            String sTrue = Boolean.TRUE.toString();

            DEBUG_PROFILE_ENTRIES = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/profile/entries")); //$NON-NLS-1$
            DEBUG_PROFILE_OBSERVER_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/profile/observer/update")); //$NON-NLS-1$
            DEBUG_PROFILE_OBSERVER_PERFORM = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/profile/observer/perform")); //$NON-NLS-1$
            DEBUG_PROFILE_STYLE_ACTIVATION = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/profile/style/activation")); //$NON-NLS-1$
            DEBUG_PROFILE_STYLE_APPLICATION = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/profile/style/application")); //$NON-NLS-1$
            DEBUG_PROFILE_STYLE_GROUP_TRACKING = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/profile/style/group/tracking")); //$NON-NLS-1$
        }
    }

}
