/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.PropertyVariables;

public final class VariableReferences {
    public static Read<List<VariableReference>> toReferences(List<PropertyVariables> vars) {
        return VariableReferences.toReferences(null, vars);
    }

    public static Read<List<VariableReference>> toReferences(final Resource expectedModel, final List<PropertyVariables> vars) {
        return new Read<List<VariableReference>>(){

            public List<VariableReference> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<VariableReference> result = new ArrayList<VariableReference>();
                for (PropertyVariables v : vars) {
                    Resource model;
                    if (expectedModel != null && !ObjectUtils.objectEquals((Object)expectedModel, (Object)(model = Variables.getModel((ReadGraph)graph, (Variable)v.getContainer())))) continue;
                    Datatype datatype = v.getVisualVariable().getPossibleDatatype(graph);
                    RVI rvi = Variables.getRVI2((ReadGraph)graph, (Variable)v.getVisualVariable());
                    result.add(VariableReference.of((RVI)rvi, (Datatype)datatype, null));
                }
                return result;
            }
        };
    }

    public static Read<List<VariableReference>> variablesToReferences(List<Variable> vars) {
        return VariableReferences.variablesToReferences(null, vars);
    }

    public static Read<List<VariableReference>> variablesToReferences(final Resource expectedModel, final List<Variable> vars) {
        return new Read<List<VariableReference>>(){

            public List<VariableReference> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<VariableReference> result = new ArrayList<VariableReference>();
                for (Variable v : vars) {
                    Resource model;
                    if (expectedModel != null && !ObjectUtils.objectEquals((Object)expectedModel, (Object)(model = Variables.getModel((ReadGraph)graph, (Variable)v)))) continue;
                    Datatype datatype = v.getPossibleDatatype(graph);
                    RVI rvi = Variables.getRVI2((ReadGraph)graph, (Variable)v);
                    result.add(VariableReference.of((RVI)rvi, (Datatype)datatype, null));
                }
                return result;
            }
        };
    }
}

