/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals.rules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.scl.runtime.function.Function4;

public enum NameRule implements ITypicalSynchronizationRule
{
    INSTANCE;


    public static NameRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource templateElement, Resource instanceElement, TypicalInfo info) throws DatabaseException {
        Function4 namingFunction = (Function4)info.bean.getAux("typicalCompositeNamingFunction");
        if (namingFunction == null) {
            return false;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource instanceComponent = graph.getPossibleObject(instanceElement, MOD.ElementToComponent);
        if (instanceComponent == null) {
            return false;
        }
        boolean result = TypicalUtil.applyTypicalModuleName(graph, instanceComponent, (Function4<ReadGraph, Resource, Resource, String, String>)namingFunction, null);
        if (result) {
            info.messageLog.add("\t\t\tname");
        }
        return result;
    }
}

