/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.TreeSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.TypicalInfoBean;

public class ReadTypicalInfo
extends UnaryRead<Resource, TypicalInfoBean> {
    public ReadTypicalInfo(Resource typicalInstance) {
        super((Object)typicalInstance);
    }

    public TypicalInfoBean perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        TypicalInfoBean info = new TypicalInfoBean();
        info.instanceElements = new TreeSet<Resource>((Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, DIA.Element)));
        info.instanceToTemplate = new THashMap(info.instanceElements.size());
        info.templateToInstance = new THashMap(info.instanceElements.size());
        info.isTemplatized = new TreeSet<Resource>();
        for (Resource instanceElement : info.instanceElements) {
            Resource templateElement = graph.getPossibleObject(instanceElement, MOD.HasElementSource);
            if (templateElement != null) {
                info.instanceToTemplate.put(instanceElement, templateElement);
                info.templateToInstance.put(templateElement, instanceElement);
            }
            if (!graph.hasStatement(instanceElement, MOD.IsTemplatized)) continue;
            info.isTemplatized.add(instanceElement);
        }
        return info;
    }
}

