/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.migration;

import java.io.PrintWriter;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.migration.NullWriter;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.WriteInterface;
import org.simantics.modeling.ModelingUtils;

public enum GuidCreationStep implements MigrationStep
{
    INSTANCE;


    public static GuidCreationStep get() {
        return INSTANCE;
    }

    public void applyTo(final IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Collection roots = (Collection)state.getProperty("currentRootResources");
        if (roots.isEmpty()) {
            return;
        }
        final PrintWriter log = (PrintWriter)MigrationUtils.getProperty((MigrationState)state, (String)"messageLogWriter", (Object)NullWriter.PRINT_INSTANCE);
        session.sync((WriteInterface)new DelayedWriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                GuidCreationStep.create(monitor, graph, roots, log);
            }
        });
    }

    private static void create(IProgressMonitor monitor, WriteGraph graph, Collection<Resource> roots, PrintWriter log) throws DatabaseException {
        log.println("## Creating missing GUID identifiers\n");
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
        ModelingUtils.createMissingGUIDs(monitor, graph, roots);
    }
}

