/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.Instruction3;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class DiagramConnectionExistence
extends Instruction3 {
    public DiagramConnectionExistence(int variable0, int variable1, int variable2) {
        super(variable0, variable1, variable2);
    }

    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        Resource element = (Resource)bindings[this.variable0];
        Resource connectionRelation = (Resource)bindings[this.variable1];
        Resource connection2 = (Resource)bindings[this.variable2];
        THashMap map = (THashMap)g.syncRequest((Read)new ConnectionsOfElement(element));
        ArrayList cs = (ArrayList)map.get((Object)connectionRelation);
        if (cs != null && cs.contains(connection2)) {
            return null;
        }
        return FAILURE;
    }

    public Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException {
        return FAILURE;
    }

    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void toString(StringBuilder b, int indent) {
        b.append("DiagramConnectionExistence");
    }

    private static class ConnectionsOfElement
    extends ResourceRead<THashMap<Resource, ArrayList<Resource>>> {
        public ConnectionsOfElement(Resource element) {
            super(element);
        }

        public THashMap<Resource, ArrayList<Resource>> perform(ReadGraph graph) throws DatabaseException {
            THashMap result = new THashMap(4);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            for (Statement stat : graph.getStatements(this.resource, STR.IsConnectedTo)) {
                for (Resource configurationRelation : graph.getObjects(stat.getPredicate(), MOD.DiagramConnectionRelationToConnectionRelation)) {
                    ArrayList l = (ArrayList)result.get((Object)configurationRelation);
                    if (l == null) {
                        l = new ArrayList(2);
                        result.put((Object)configurationRelation, l);
                    }
                    l.addAll(graph.getObjects(stat.getObject(), DIA.IsConnectorOf));
                }
            }
            return result;
        }
    }
}

