/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.commandlog.NewCompositeCommand;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function3;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.ui.workbench.action.DefaultActions;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;
import org.simantics.utils.logging.TimeLogger;

public class NewCompositeActionFactory
implements ActionFactory {
    Resource compositeType;
    String defaultName;

    public NewCompositeActionFactory(Resource compositeType, String defaultName) {
        this.compositeType = compositeType;
        this.defaultName = defaultName;
    }

    public Runnable create(Object target_) {
        final Resource target = (Resource)target_;
        return new Runnable(){

            @Override
            public void run() {
                TimeLogger.resetTimeAndLog((String)"NewCompositeActionFactory: create composite");
                DatabaseJob job = new DatabaseJob("Create Diagram"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Create Diagram...", -1);
                        try {
                            Resource composite = NewCompositeActionFactory.createComposite((this).NewCompositeActionFactory.this.compositeType, (this).NewCompositeActionFactory.this.defaultName, target);
                            if (Commands.isRecording() && composite != null) {
                                Commands.record((Command)new NewCompositeCommand(composite, (this).NewCompositeActionFactory.this.compositeType, (this).NewCompositeActionFactory.this.defaultName, target));
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (CancelTransactionException e) {
                            Status status = new Status(1, "org.simantics.modeling", e.getMessage());
                            return status;
                        }
                        catch (DatabaseException e) {
                            Status status = new Status(4, "org.simantics.modeling", e.getMessage(), (Throwable)e);
                            return status;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                job.schedule();
            }
        };
    }

    private static Resource createComposite(Resource compositeType, String defaultName, Resource target) throws DatabaseException {
        Session session = Simantics.getSession();
        session.markUndoPoint();
        Function3 instantiator = (Function3)session.syncRequest(NewCompositeActionFactory.possibleCompositeInstantiator(compositeType));
        if (instantiator != null) {
            return (Resource)instantiator.apply((Object)compositeType, (Object)defaultName, (Object)target);
        }
        Resource composite = (Resource)session.syncRequest(NewCompositeActionFactory.createCompositeRequest(target, defaultName, compositeType));
        DefaultActions.asyncPerformDefaultAction((Session)session, (Object)composite, (boolean)false, (boolean)false, (boolean)true);
        return composite;
    }

    private static Read<Function3<Resource, String, Resource, Resource>> possibleCompositeInstantiator(final Resource compositeType) {
        return new UniqueRead<Function3<Resource, String, Resource, Resource>>(){

            public Function3<Resource, String, Resource, Resource> perform(ReadGraph graph) throws DatabaseException {
                return (Function3)graph.getPossibleRelatedValue2(compositeType, StructuralResource2.getInstance((ReadGraph)graph).Composite_instantiationFunction);
            }
        };
    }

    public static WriteResult<Resource> createCompositeRequest(final Resource target, final String defaultName, final Resource compositeType) {
        return new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                return NewCompositeActionFactory.createComposite(graph, target, defaultName, compositeType);
            }
        };
    }

    public static Resource createComposite(WriteGraph graph, Resource target, String defaultName, Resource compositeType) throws DatabaseException {
        String name = NameUtils.findFreshName((ReadGraph)graph, (String)defaultName, (Resource)target, (Resource)Layer0.getInstance((ReadGraph)graph).ConsistsOf, (String)"%s%d");
        return StructuralUtils.newComponent((WriteGraph)graph, (Resource)target, (String)name, (Resource)compositeType);
    }
}

